#include <windows.h>
#include "Ex2_VS.h" 

int culori[10] = {  RED, WHITE, BLUE, YELLOW, GREEN, 
                    BROWN, CYAN, MAGENTA, LIGHTRED, LIGHTGREEN };

CERC c[10]; // 10 cercuri

int main()
{
int CercCurent = 0, gata = 0, k;

    InitializeGraphicMode();
    
    // initializarea cercurilor
    for (k = 0; k < 10; k++)
    {
        c[k].x = 50 * k + 100;
        c[k].y = 200;
        c[k].r = 10 * k + 25;
        c[k].c = culori[k];
        Afiseaza(&c[k]);        // si afisarea lor
    }

    while (!gata)
        switch (_getch())     
        {
        case ESC:             
            gata = 1;         
            break;
        case TAB:             
            CercCurent++;     
            CercCurent %= 10;  
            break;
        case 0xE0:            // pentru sageti se genereaza intai 0xE0
            switch (_getch()) //   apoi un cod specific
            {
            case LEFT:  Muta(&c[CercCurent],-10,  0); break;
            case RIGHT: Muta(&c[CercCurent], 10,  0); break;
            case UP:    Muta(&c[CercCurent],  0,-10); break;
            case DOWN:  Muta(&c[CercCurent],  0, 10); break;
            }
            break;
        case 0x00:            // pentru F1, F2 se genereaza intai 0x00
            switch (_getch()) //   apoi un cod specific
            {
            case F1: Creste(&c[CercCurent],+10); break;
            case F2: Creste(&c[CercCurent],-10); break;
            }
            break;
         }

    CloseGraphicMode();		//inchiderea modului grafic
    return 0;
}

void Afiseaza(CERC* ce)
//*********************
// desenare a cercului
{
    circle(ce->x, ce->y, ce->r, ce->c);
}

void Sterge(CERC* ce)
//*******************
// stergere a cercului
{
    circle(ce->x, ce->y, ce->r, BLACK);
}

void Muta(CERC *ce, int dx, int dy)
//*********************************
// functie care modifica pozitia unui cerc 
{
    Sterge(ce);     // stergere cerc	
    
    ce->x += dx;    // modificare pozitie x      		    
    ce->y += dy;    // modificare pozitie y
      
    Afiseaza(ce);   // desenare in noua pozitie	
}

void Creste(CERC* ce, int dr)
//***************************
// functie care modifica raza unui cerc 
{
    Sterge(ce);     // stergere cerc	

    ce->r += dr;    // modificare raza      		    

    Afiseaza(ce);   // desenare in noua pozitie	
}

//**********************************************************
// cod considerat "de biblioteca", luat ca atare
//**********************************************************

// pentru utilizare modul grafic
HWND console_handle;
HDC device_context;

void InitializeGraphicMode()
//***************************
// functie care face trecerea din modul text in modul grafic
{
    console_handle = GetConsoleWindow();
    device_context = GetDC(console_handle);
    Sleep(100);
}

void CloseGraphicMode()
//*********************
// functie care inchide modul grafic
{
    ReleaseDC(console_handle, device_context);
}

void circle(int x, int y, int r, int c)
//*************************************
// functie care deseneaza un cerc (x,y,raza,culoare)
{
    HPEN pen = CreatePen(PS_SOLID, 1, (COLORREF)c);
    SelectObject(device_context, pen);
    SelectObject(device_context, GetStockObject(NULL_BRUSH));
    Ellipse(device_context, x - r, y - r, x + r, y + r);
    DeleteObject(pen);
}
