#include <windows.h>
#include "Ex1_VS.h" //includerea fisierului antet propriu "Ex1_VS.h" 
                    // care trebuie existe in directorul curent.

// prototipuri de functii considerate "de biblioteca"
void InitializeGraphicMode(void);
void CloseGraphicMode();
void circle(int, int, int, int);

// prototip functie proprie
void Muta(int* x, int* y, int r, int c, int dx, int dy);

// variabile globale, pentru un cerc vom avea urmatoarele date:
// x, y = coordonatele centrului cercului
// r    = raza cercului
// c    = culoarea cercului
// se vor defini 3 cercuri

//variabilele pentru cele 3 cercuri
int x1,y1,r1,c1, x2,y2,r2,c2, x3,y3,r3,c3; 

int main()
{
// variabile locale

int CercCurent = 0;
    // variabila care indica cercul curent, poate lua 3 valori:
    // 0 - pentru cercul x1, y1, r1, c1
    // 1 - pentru cercul x2, y2, r2, c2
    // 2 - pentru cercul x3, y3, r3, c3
    
int gata = 0;
int dx, dy;

    // cod
    InitializeGraphicMode();     // se face trecerea in modul grafic
    
    // initializarea variabilelor pt. cerc 1
    x1 = 100; y1 = 200; r1 = 25; c1 = YELLOW;                  
    circle(x1, y1, r1, c1);     // se deseneaza cercul 1
    
    // initializarea variabilelor pt. cerc 2
    x2 = 300; y2 = 200; r2 = 50; c2 = RED; 
    circle(x2, y2, r2, c2);     // se deseneaza cercul 2
    
    // initializarea variabilelor pt. cerc 3    
    x3 = 500;y3 = 200;r3 = 100; c3 = BLUE;
    circle(x3, y3, r3, c3);     // se deseneaza cercul 3

    // se intra intr-o bucla in care se ramane atata timp cat gata=0
    while (!gata)
        switch (_getch())     // se asteapta apasarea unei taste
        {
        case ESC:             // daca s-a apasat ESC se va iesi din bucla
            gata = 1;         // prin valoarea 1 pe care o primeste gata
            break;
        case TAB:             // daca s-a apasat TAB
            CercCurent++;     // trecem la cercul urmator
            CercCurent %= 3;  //   dupa cercul 2 urmeaza cercul 0
            break;
        case 0xE0:            // pentru sageti se genereaza intai 0xE0
            switch (_getch()) // apoi un cod specific
            {
            case LEFT:  dx = -10;dy =   0;break;    // 10 pixeli la stanga
            case RIGHT: dx =  10;dy =   0;break;    // 10 pixeli la dreapta
            case UP:    dx =   0;dy = -10;break;    // 10 pixeli in sus
            case DOWN:  dx =   0;dy =  10;break;    // 10 pixeli in jos
            default:    dx =   0;dy =   0;break;
            }
            // in functie de sageata apasata s-au dat valori pt. dx si dy

            // abia acum se muta cu dx si dy cercul curent 
            switch (CercCurent)
            {
            case 0:                             // daca CercCurent=0
                Muta(&x1, &y1, r1, c1, dx, dy); //  mutarea cercului 1
                break;
            case 1:                             // daca CercCurent=1
                Muta(&x2, &y2, r2, c2, dx, dy); //  mutarea cercului 2
                break;
            case 2:                             // daca CercCurent=2
                Muta(&x3, &y3, r3, c3, dx, dy); //  mutarea cercului 3
                break;
            }
            break;
         }

    CloseGraphicMode();		//inchiderea modului grafic
    return 0;
}

void Muta(int* x, int* y, int r, int c, int dx, int dy)
//*****************************************************
// functie care muta un cerc cu deplasamentele dx si dy
{
    // sterge cercul din pozitia veche, prin scrierea 
    // unui cerc de culoarea fondului (negru) peste el
    circle(*x, *y, r, BLACK);  	
    
    // sunt modificate coordonatele centrului cercului
    *x += dx;           // mutare pe orizontala      		    
    *y += dy;           // mutare pe verticala
    
    // desenare a cercului in noua pozitie 
    circle(*x, *y, r, c);  	
}


//**********************************************************
// cod considerat "de biblioteca", luat ca atare
//**********************************************************

// pentru utilizare modul grafic
HWND console_handle;
HDC device_context;

void InitializeGraphicMode()
//***************************
// functie care face trecerea din modul text in modul grafic
{
    console_handle = GetConsoleWindow();
    device_context = GetDC(console_handle);
    Sleep(100);
}

void CloseGraphicMode()
//*********************
// functie care inchide modul grafic
{
    ReleaseDC(console_handle, device_context);
}

void circle(int x, int y, int r, int c)
//*************************************
// functie care deseneaza un cerc (x,y,raza,culoare)
{
    HPEN pen = CreatePen(PS_SOLID, 1, (COLORREF)c);
    SelectObject(device_context, pen);
    SelectObject(device_context, GetStockObject(NULL_BRUSH));
    Ellipse(device_context, x - r, y - r, x + r, y + r);
    DeleteObject(pen);
}
